<?php
$name = $email = $message = "";
$name_err = $email_err = $message_err = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (empty(trim($_POST["name"]))) {
        $name_err = "Please enter your name.";
    } else {
        $name = trim($_POST["name"]);
    }

    if (empty(trim($_POST["email"]))) {
        $email_err = "Please enter your email address.";
    } elseif (!filter_var(trim($_POST["email"]), FILTER_VALIDATE_EMAIL)) {
        $email_err = "Invalid email format.";
    } else {
        $email = trim($_POST["email"]);
    }

    if (empty(trim($_POST["message"]))) {
        $message_err = "Please enter a message.";
    } else {
        $message = trim($_POST["message"]);
    }

    if (empty($name_err) && empty($email_err) && empty($message_err)) {
        $to = "thomasb.2027@mtchs.org";
        $subject = "New Contact Form Submission";
        $body = "You have received a new message from $name.\n\n" .
                "Email: $email\n\n" .
                "Message:\n$message";
        $headers = "From: $email";

        if (mail($to, $subject, $body, $headers)) {
            header("Location: response.php?status=success");
            exit();
        } else {
            header("Location: response.php?status=error");
            exit();
        }
    }
}
?>
